/**   Start scripts by invoking Java class, e.g. 			
 **   java ScriptInterpreter "filename"   				
 **									
 **   The script gets called by a Java program and uses Java API and	 
 **   BSF to build an AWT GUI frame in a scripting language		
 ********************************************************************** **/


/**     Define "ooRexx shortcuts" to create Java components  **/    
/****************************************************************/
BorderLayout = 'java.awt.BorderLayout'
Button = 'java.awt.Button'
Choice = 'java.awt.Choice'
Color = 'java.awt.Color'
Frame = 'java.awt.Frame'
Label = 'java.awt.Label'
Panel = 'java.awt.Panel'
Scrollbar = 'java.awt.Scrollbar'

EAST = .bsf~bsf.getStaticValue(BorderLayout, "EAST")
WEST = .bsf~bsf.getStaticValue(BorderLayout, "WEST")
SOUTH = .bsf~bsf.getStaticValue(BorderLayout, "SOUTH")
NORTH = .bsf~bsf.getStaticValue(BorderLayout, "NORTH")
HORIZONTAL = .bsf~bsf.getStaticValue(Scrollbar, "HORIZONTAL")
CENTER = .bsf~bsf.getStaticValue(BorderLayout, "CENTER")
LCENTER = .bsf~bsf.getStaticValue(Label, "CENTER")

black = .bsf~bsf.getStaticValue("java.awt.Color", "black")
blue = .bsf~bsf.getStaticValue("java.awt.Color", "blue")
green = .bsf~bsf.getStaticValue("java.awt.Color", "green")
red = .bsf~bsf.getStaticValue("java.awt.Color", "red")
lightGray = .bsf~bsf.getStaticValue("java.awt.Color", "lightGray")

/**	Create GUI components    **/ 
/**********************************/
frame = .bsf~new(Frame, "AWT Frame, implementiert in open Object Rexx ")
layout = .bsf~new(BorderLayout)
panel = .bsf~new(Panel, layout)

scroll = .bsf~new(Scrollbar, HORIZONTAL)
label = .bsf~new(Label, "Servus")
button = .bsf~new(Button, "ooRexx Button")

color = .bsf~new(Choice)
color ~~add("green") ~~add("blue") ~~add("red")

text = .bsf~new(Choice)
text ~~add("Hallo!") ~~add("Ciao.") ~~add("Bis bald...")

panel~setBackground(black)
button~setBackground(lightGray)	
label~setAlignment(LCENTER)
	
/**	Pack the GUI    **/	 
/*************************/	
panel~add(EAST , color)
panel~add(WEST, text)
panel~add(SOUTH, scroll)

frame~add(NORTH, label)
frame~add(CENTER, button)
frame~add(SOUTH, panel)

/**    Add event handler to components	**/
/****************************************/
frame~bsf.addEventListener('window', 'windowClosing', 'call BSF "exit"')
frame~bsf.addEventListener('window', 'windowDeiconified', 'label~setText("Willkommen zurck")')

color~bsf.addEventListener('item', 'itemStateChanged', 'call changeColor color, label')
text~bsf.addEventListener('item', 'itemStateChanged', 'label~setText(text~getSelectedItem())')
button~bsf.addEventListener('action', 'actionPerformed', 'call switchLabel button')

/**	Display frame with properties	**/ 
/*****************************************/
frame~setSize(400, 400)
frame~setLocation(300, 300)
frame~pack()
frame~show()

/** 	bsf.pollEventText (any event) gets interpreted costantly   **/ 
/********************************************************************/
do forever
	INTERPRET .bsf~bsf.pollEventText
	if result="SHUTDOWN, REXX !" then leave
end 
exit

/** 	event handler for choice field "color" **/ 
/********************************************* **/
changeColor: procedure 
	use arg color, label

	label~setBackground( .bsf~bsf.getStaticValue('java.awt.Color', color~getSelectedItem()))
	label~setFont(.bsf~new('java.awt.Font', 'Dialog', .bsf~bsf.getStaticValue('java.awt.Font', 'BOLD'), 14))
return

/** 	event handler for button "button"   	**/
/*********************************************  **/
switchLabel: procedure 
	use arg button

	btnLabel = bsf('lookupBean','btnLabel')
	button~setLabel(btnLabel)
return


::requires BSF.cls  -- adds BSF support to Java and scripts
